
// OPOS_DKDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OPOS_DK.h"
#include "OPOS_DKDlg.h"
#include "afxdialogex.h"
#include "OposCash.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// COPOS_DKDlg dialog




COPOS_DKDlg::COPOS_DKDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(COPOS_DKDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COPOS_DKDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CASHDRAWER1, m_opos);
	DDX_Control(pDX, IDC_LIST1, m_log);
	DDX_Control(pDX, IDC_EDITOPEN, m_EditOpen);
}

BEGIN_MESSAGE_MAP(COPOS_DKDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &COPOS_DKDlg::Open)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &COPOS_DKDlg::OPOS_CLOSE)
	ON_BN_CLICKED(IDC_BUTTON_OPENDK, &COPOS_DKDlg::OpenDK)
END_MESSAGE_MAP()


// COPOS_DKDlg message handlers

BOOL COPOS_DKDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_EditOpen.SetWindowTextW(L"DKSO");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void COPOS_DKDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COPOS_DKDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COPOS_DKDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void COPOS_DKDlg::Open()
{
	CString str,str_;
	long val,cx=0;

	m_log.ResetContent();
	GetDlgItem(IDC_EDITOPEN)->GetWindowText(str);
	BSTR str2 = str.AllocSysString();  

	str_.Format( L"Open:%d", m_opos.Open(str2));	
	m_log.InsertString(cx++, str_);

	str_.Format( L"Claimed:%d", m_opos.get_Claimed());	
	m_log.InsertString(cx++, str_);

	str_.Format( L"ClaimDevice:%d", m_opos.ClaimDevice(1000));	
	m_log.InsertString(cx++, str_);

	m_opos.put_DeviceEnabled(1);
	str_.Format( L"DeviceEnabled:%d", m_opos.get_DeviceEnabled());	
	m_log.InsertString(cx++, str_);

	str_.Format( L"Claimed:%d", m_opos.get_Claimed());	
	m_log.InsertString(cx++, str_);	

	val = m_opos.CheckHealth(1);
	str_.Format(L"Health:%d",val);
	m_log.InsertString( cx++, str_);

	str_.Format(L"HealthText:%s", m_opos.get_CheckHealthText());
	m_log.InsertString( cx++, str_);
	SysFreeString(str2);
}


void COPOS_DKDlg::OPOS_CLOSE()
{
	CString str,str_;
	long val,cx=0;
	m_log.ResetContent();

	m_opos.put_DeviceEnabled(false);
	str_.Format( L"DeviceEnabled:%d", m_opos.get_DeviceEnabled());	
	m_log.InsertString(cx++, str_);

	str_.Format( L"ReleaseDevice:%d", m_opos.ReleaseDevice());	
	m_log.InsertString(cx++, str_);

	str_.Format( L"Close:%d", m_opos.Close());	
	m_log.InsertString(cx++, str_);	
}

void COPOS_DKDlg::OpenDK()
{
	m_opos.OpenDrawer();
}
BEGIN_EVENTSINK_MAP(COPOS_DKDlg, CDialogEx)
	ON_EVENT(COPOS_DKDlg, IDC_CASHDRAWER1, 5, COPOS_DKDlg::StatusUpdateEventCashdrawer1, VTS_I4)
END_EVENTSINK_MAP()


void COPOS_DKDlg::StatusUpdateEventCashdrawer1(long Data)
{
	CString str_;
	m_log.ResetContent();
	//Make messages for the each event information.

	switch( Data )
	{
	case CASH_SUE_DRAWERCLOSED:        // Printer cover is open.	
		m_log.InsertString(0, L"Cash drawer is close!");
		break;
	case CASH_SUE_DRAWEROPEN:			// No receipt paper.
		m_log.InsertString(0, L"Cash drawer is open!");
		break;
	default:
		str_.Format(L"Un-define event:0x%x",Data);	
		m_log.InsertString(0, str_);
	}
}
